xquery version "3.1";
(:~
    Creates a Markdown page listing all motifs and their respective occurrences
    in the source documents.
:)
declare namespace tei="http://www.tei-c.org/ns/1.0";
declare namespace motifs="http://ahiqar.uni-goettingen.de/ns/motifs";

import module namespace commons="http://ahiqar.uni-goettingen.de/ns/commons" at "commons.xqm";

let $cache-name := "ahiqar-motifs"
let $cache := cache:create($cache-name, map {})

let $motifs as map() := map{
    "adherence_wisdom": map{
        "keyword": "Adherence to wisdom",
        "category": "Wisdom, Knowledge",
        "description": "The necessity and Priority of being wise"
        },
    "air_castle": map{
        "keyword": "Air Castle",
        "category": "Riddle",
        "description": "The riddle of the air castle"
        },
    "beauty_caducity": map{
        "keyword": "Beauty/Caducity",
        "category": "Women, caducity, Social relationship",
        "description": "The relationship to women and the caducity of their beauty"
        },
    "burden_debt": map{
        "keyword": "Burden/Debt",
        "category": "Commitment",
        "description": "The state of a person with commitments"
        },
    "caution_against_powerful": map{
        "keyword": "Caution against powerful",
        "category": "Social relationship",
        "description": "The relationship to powerful persons or forces"
        },
    "death_age": map{
        "keyword": "Death age",
        "category": "Caducity, Social standing, Death, Honour",
        "description": "The relationship to older persons and the caducity of human beings"
        },
    "discernment": map{
        "keyword": "Discernment",
        "category": "Reflection, Behaviour",
        "description": "The righteous assessment of a situation"
        },
    "disciplining_of_sons":    map{
        "keyword": "Disciplining of son(s)",
        "category": "Social relationship, Family",
        "description": "The instruction and education of one's sons"
        },
    "enemies": map{
        "keyword": "Enemies",
        "category": "Social relationship",
        "description": "The relationship and attitude to adversial persons"
        },
    "good_name": map{
        "keyword": "Good name",
        "category": "Social standing, Honour",
        "description": "The income of wise and righteous deeds"
        },
    "image_king": map{
        "keyword": "Image king",
        "category": "Politics, King",
        "description": "The image of the Assyrian king"
        },
    "intrigue": map{
        "keyword": "Intrigue",
        "category": "Politics",
        "description": "Nadan's actions against Ahiqar"
        },
    "keeping_secrets": map{
        "keyword": "Keepind secrets",
        "category": "Social relationship, Loyalty",
        "description": "How to handle secrets"
        },
    "loyal_obligation_gods": map{
        "keyword": "Loyal obligation to God(s)",
        "category": "God, Loyality",
        "description": "Allegiance and relation to God(s)"
        },
    "meekness_showing_respect": map{
        "keyword": "Meekness showing respect",
        "category": "Social relationship",
        "description": "To behave with respect and meekness"
        },
    "obeying_parents": map{
        "keyword": "Obeying parents",
        "category": "Social relationship, Loyalty",
        "description": "Relationship to parents"
        },
    "parable_animals": map{
        "keyword": "Parable animals",
        "category": "Parables, Animals",
        "description": "Parables including references to animals"
        },
    "parable_plants":map{
        "keyword": "Parable plants",
        "category": "Parables, Plants",
        "description": "Parables including references to plants"
        },
    "quarrel": map{
        "keyword": "Quarrel",
        "category": "Social relationship, Social behaviour",
        "description": "How to handle conflicts and quarrels"
        },
    "richness_poverty": map{
        "keyword": "Richness poverty",
        "category": "Social position",
        "description": "The significance of richness resp. poverty"
        },
    "royal_challenges": map{
        "keyword": "Royal challenges",
        "category": "Politics",
        "description": "Political tasks for the king"
        },
    "self_examination_reflection": map{
        "keyword": "Self-examination, self-reflection",
        "category": "Self-examination",
        "description": "Reflection on one's attitude and behaviour"
        },
    "social_contacts_family": map{
        "keyword": "Social contacts family",
        "category": "Social relationship",
        "description": "Social contacts with persons within the family"
        },
    "social_contacts_no_family": map{
        "keyword": "Social contacts no family",
        "category": "Social relationship",
        "description": "Social contacts with persons outside the family"
        },
    "successful_courtier": map{
        "keyword": "Successful courtier",
        "category": "Politics",
        "description": "Rehabilitation of Ahiqar"
        },
    "temptress_women": map{
        "keyword": "Temptress women",
        "category": "Social relationship, Women",
        "description": "Relationship to temptress women"
        },
    "treatment_slaves": map{
        "keyword": "Treatment slaves",
        "category": "Social relationship",
        "description": "Relationship and treatment of slaves and maidservants"
        },
    "truth_lying": map{
        "keyword": "Truth lying",
        "category": "Social behaviour",
        "description": "Attitude towards truth or falsehood"
        },
    "wise_fool_sinful": map{
        "keyword": "Wise/fool/sinful behaviour resp. persons",
        "category": "Wisdom, Social behaviour, Social relationship",
        "description": "Relation to wise, fool and sinful persons and their behaviour"
        }
    }

let $elements := collection($commons:tmp)//motifs:*

let $pages :=
    for $key at $pos in map:keys($motifs)
    order by $key
    let $maps :=
        for $element in $elements
        where local-name($element) eq $key
        let $uri := $element/base-uri() =>  replace($commons:tmp || "|\.me\.xml", "")
        let $info :=
            if( not(cache:keys($cache-name) = $uri) )
            then
                let $infos := commons:get-resource-information($uri)
                let $caching := cache:put($cache-name, $uri, $infos)
                return
                    $infos
            else cache:get($cache-name, $uri)
        let $pageNum := string($element/preceding::tei:pb[1]/@n)
        let $pageNumIndex :=
            let $pageNums := $element/ancestor::tei:text[1]//tei:pb/string(@n)
            return index-of($pageNums, $pageNum) - 1
        let $language := $info?languageCollection
        order by $language
        return
            map{
                "title": $info?title,
                "language": $language,
                "link":
                    "[" || $pageNum || "](/" || $language || ".html?tido=m" || $info?manifestIndexNumber || "_i" || $pageNumIndex || ")"
            }
       
    let $heading := "### " || $motifs($key)?keyword || "&#x000A;"
    let $category := "Category: " ||  $motifs($key)?category 
    let $description := "Description: " || $motifs($key)?description 
    
    let $occurences := "#### Occurences"
    let $listItems :=
        for $lang in distinct-values( $maps?language )
        return(
            "- " || $lang,
            string-join((
                for $title in distinct-values($maps[?language eq $lang]?title)
                let $links := distinct-values(($maps[?language eq $lang][?title eq $title]?link))
                let $count := count($links)
                order by $count descending
                return
                    "    - " || $title || " [" || $count || " occurence" ||
                    (if ($count gt 1) then "s" else "")
                    || "]" || ": " || string-join($links, ", ")
                ), "&#x000A;"))
    return
        string-join((
            $heading,
            $category,
            $description,"",
            $occurences, "",
            $listItems, ""
        ), "&#x000A;")

return
"---
title: Motifs
layout: Layout
hide_sidebar: false
---

# {{ $frontmatter.title }}

In 1979, Max Küchler began his work on Ahiqar, which he published in his study
 _Frühjüdische Weisheitstraditionen_ (Fribourg/Göttingen 1979). He started with
 a collection of themes in the Ahiqar story in the form of notes. In connection
 with this, we have collected and marked the central motifs and themes of the
 story as they appear in the various textual witnesses. This process aids in
 clarifying, correcting, and expanding the history of motifs in this story.
 Below is a brief description of each motif:

" || string-join($pages)